if unsupported then return end

-- localize functions to improve performance
local set_environment_region,obj_mark_for_deletion,network_is_server,obj_check_hitbox_overlap,obj_has_behavior_id = set_environment_region,obj_mark_for_deletion,network_is_server,obj_check_hitbox_overlap,obj_has_behavior_id

--- @param o Object
function obj_hide(o)
    o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
end

--- @param o Object
function obj_mark_for_deletion_on_sync(o)
    if gNetworkPlayers[0].currAreaSyncValid then obj_mark_for_deletion(o) end
end

-- Unwanted Behaviors
hook_behavior(id_bhvStar, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHoot, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvWaterLevelDiamond, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvKoopaRaceEndpoint, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvCapSwitch, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvCapSwitchBase, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvRacingPenguin, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenStar, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvSpawnedStar, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvUnusedFakeStar, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenRedCoinStar, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenStarTrigger, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvRedCoinStarMarker, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvOpenableGrill, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvToadMessage, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvWhirlpool, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvOrangeNumber, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvStarSpawnCoordinates, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvBubba, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

if game ~= GAME_SUPER_LUIGI_64_THE_FLOWER_CUP then
    hook_behavior(id_bhvChainChompGate, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
end

--- @param m MarioState
local function before_phys_step(m)
    if m.playerIndex ~= 0 then return end

    if m.pos.y + 40 < gGlobalSyncTable.floodLevel and gNetworkPlayers[m.playerIndex].currLevelNum == gLevels[gGlobalSyncTable.level].level and gGlobalSyncTable.floodGravity then
        m.vel.y = m.vel.y + 2
        m.peakHeight = m.pos.y
    end

	-- remove slide surfaces from levels
	if gLevels[gGlobalSyncTable.level].overrideSlide == true then
        if m.area.terrainType == TERRAIN_SLIDE then
            m.area.terrainType = TERRAIN_STONE
		end
	    if m.floor ~= nil and (m.floor.type == SURFACE_CLASS_VERY_SLIPPERY or m.floor.type == SURFACE_CLASS_SLIPPERY or m.floor.type == SURFACE_HARD_SLIPPERY or m.floor.type == SURFACE_HARD_VERY_SLIPPERY or m.floor.type == SURFACE_NOISE_SLIPPERY or m.floor.type == SURFACE_NOISE_VERY_SLIPPERY or m.floor.type == SURFACE_NOISE_VERY_SLIPPERY_73 or m.floor.type == SURFACE_NOISE_VERY_SLIPPERY_74 or m.floor.type == SURFACE_SLIPPERY or m.floor.type == SURFACE_VERY_SLIPPERY or m.floor.type == SURFACE_NO_CAM_COL_SLIPPERY or m.floor.type == SURFACE_NO_CAM_COL_VERY_SLIPPERY or m.floor.type == SURFACE_ICE) then
           m.floor.type = SURFACE_HARD_NOT_SLIPPERY
	    end
	end
end

-- removes water from levels, credits to EmeraldLockdown
local function remove_water()
    if gLevels[gGlobalSyncTable.level].overrideWater == true
    and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        for i = 0, 10 do
            set_water_level(i, -90000, false)
        end
    end

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        if gLobbies[gGlobalSyncTable.lobby].overrideWater == true then
            for i = 0, 10 do
                set_water_level(i, -90000, false)
            end
        end
    end
end

--- @param m MarioState
--- @param o Object
local function allow_interact(m, o)
    -- don't let spectators interact and don't allow warp door interactions	
    if  m.action == ACT_SPECTATOR
    or m.action == ACT_FOLLOW_SPECTATOR
    or o.oInteractType == INTERACT_WARP_DOOR then
        return false
    end

    -- disable warp interactions in lobby
	if o.oInteractType == INTERACT_WARP then
        if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
	   	    return false
	 	end
	end

    -- check if the object is a player that's a spectator as well
    if o.behavior == get_behavior_from_id(id_bhvMario) then
        for i = 0, MAX_PLAYERS - 1 do
            if gMarioStates[i].marioObj == o then
                if m.action == ACT_SPECTATOR or m.action == ACT_FOLLOW_SPECTATOR then
                    return false
                end
            end
        end
    end
end

local function on_death()
    local m = gMarioStates[0]

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        vec3f_set(m.pos, gLobbies[gGlobalSyncTable.lobby].spawn.x, gLobbies[gGlobalSyncTable.lobby].spawn.y + 750, gLobbies[gGlobalSyncTable.lobby].spawn.z)
        m.faceAngle.y = gLobbies[gGlobalSyncTable.lobby].spawn.yaw
        set_mario_action(m, ACT_SPAWN_NO_SPIN_AIRBORNE, 0)
        m.vel.y = 0
        m.flags = m.flags | MARIO_VANISH_CAP
        m.capTimer = 60
        if m.floor and (m.floor.type == SURFACE_INSTANT_QUICKSAND or m.floor.type == SURFACE_INSTANT_MOVING_QUICKSAND) then
            soft_reset_camera(m.area.camera)
        end
    elseif gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and gGlobalSyncTable.respawn then
        vec3f_set(m.pos, get_spawn_pos().x, get_spawn_pos().y + 750, get_spawn_pos().z)
        m.faceAngle.y = get_spawn_pos().yaw
        set_mario_action(m, ACT_SPAWN_NO_SPIN_AIRBORNE, 0)
        m.vel.y = 0
        if m.floor and (m.floor.type == SURFACE_INSTANT_QUICKSAND or m.floor.type == SURFACE_INSTANT_MOVING_QUICKSAND) then
            soft_reset_camera(m.area.camera)
        end
    else
        m.health = 0xFF
    end
    return false
end

-- Romhack Camera
invalidCameraModes = {
    [CAMERA_MODE_ROM_HACK] = true,
    [CAMERA_MODE_C_UP] = true,
    [CAMERA_MODE_WATER_SURFACE] = true,
    [CAMERA_MODE_BEHIND_MARIO] = true
}

---@param m MarioState
local function mario_update(m)
    if m.playerIndex ~= 0 then return end

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvWarpPipe))
        obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvBooCage))
        obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvRedCoin))

        if gGlobalSyncTable.lobbyBosses == false then
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvBowser))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvBowserBodyAnchor))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvBowserTailAnchor))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvBalconyBigBoo))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvWigglerHead))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvWigglerBody))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvKingBobomb))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvWhompKingBoss))
            obj_mark_for_deletion(obj_get_first_with_behavior_id(id_bhvEyerokBoss))
        end

    	-- pvp while in lobby
	    if gGlobalSyncTable.lobbyPvp == true then
            gServerSettings.playerInteractions = PLAYER_INTERACTIONS_PVP
        else
            gServerSettings.playerInteractions = PLAYER_INTERACTIONS_NONE
	    end
    end

    if not romhackCam then
        camera_set_use_course_specific_settings(1)
        return
    end

    if not invalidCameraModes[m.area.camera.mode] then
        set_camera_mode(m.area.camera, CAMERA_MODE_ROM_HACK, 0)
    end

    camera_set_use_course_specific_settings(0)
    rom_hack_cam_set_collisions(romhackCamCollision)
    camera_romhack_allow_centering(1)

    if not showSettings then
        camera_romhack_allow_dpad_usage(1)
    else
        camera_romhack_allow_dpad_usage(0)
    end
	
    for i in pairs(gActiveMods) do
        if gActiveMods[i].name:find("Nightmare Levels") then
            LEVEL_NIGHTMARE_BOB = level_register('level_nightmare_bob_entry', COURSE_NONE, 'Chain Chomp Battlefield', 'n-bob', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_WF = level_register('level_nightmare_wf_entry', COURSE_NONE, 'Infernal Fortress', 'n-wf', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_JRB = level_register("level_nightmare_jrb_entry", COURSE_NONE, "Devil's Bay", "n-jrb", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_CCM = level_register('level_nightmare_ccm_entry', COURSE_NONE, 'Ice, Fire Mountain', 'n-ccm', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_BBH = level_register("level_nightmare_bbh_entry", COURSE_NONE, "Chuckya's Mansion", "n-bbh", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_PSS = level_register("level_nightmare_pss_entry", COURSE_NONE, "Amp Slide", "n-pss", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_HMC = level_register('level_nightmare_hmc_entry', COURSE_NONE, 'Hazy Volcano Cave', 'n-hmc', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_LLL = level_register('level_nightmare_lll_entry', COURSE_NONE, 'Volcanic Activity', 'n-lll', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_SSL = level_register('level_nightmare_ssl_entry', COURSE_NONE, 'Pyramid Of Precision', 'n-ssl', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_DDD = level_register('level_nightmare_ddd_entry', COURSE_NONE, 'Abyss Of Death', 'n-ddd', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_SL = level_register("level_nightmare_sl_entry", COURSE_NONE, "Snowman's Cryogenization", "n-sl", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_WDW = level_register('level_nightmare_wdw_entry', COURSE_NONE, 'Remnants Of The World', 'n-wdw', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_THI = level_register('level_nightmare_thi_entry', COURSE_NONE, 'Doomed Island', 'n-thi', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_TTC = level_register('level_nightmare_ttc_entry', COURSE_NONE, 'Time Collapsion', 'n-ttc', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_RR = level_register('level_nightmare_rr_entry', COURSE_NONE, 'Eternal Ride', 'n-rr', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_COTMC = level_register('level_nightmare_cotmc_entry', COURSE_NONE, 'Mystic Cave', 'n-cotmc', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_VCUTM = level_register('level_nightmare_vcutm_entry', COURSE_NONE, 'Lost Palace', 'n-vcutm', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_TOTWC = level_register('level_nightmare_totwc_entry', COURSE_NONE, 'Deadly Towers', 'n-totwc', 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_BITDW = level_register("level_nightmare_bitdw_entry", COURSE_NONE, "Bowser's Cursed World", "n-bitdw", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_BITFS = level_register("level_nightmare_bitfs_entry", COURSE_NONE, "Bowser's Personal Hell", "n-bitfs", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_BITS = level_register("level_nightmare_bits_entry", COURSE_NONE, "Bowser's Heartrending Dimension", "n-bits", 28000, 0x08, 0x08, 0x08)
            LEVEL_NIGHTMARE_CG = level_register('level_nightmare_castle_grounds_entry', COURSE_NONE, 'Firefield Grounds', 'n-cg', 28000, 0x08, 0x08, 0x08)	
	
    local nightmareLevels = {
        [LEVEL_NIGHTMARE_BOB] = true,
        [LEVEL_NIGHTMARE_WF] = true,
        [LEVEL_NIGHTMARE_JRB] = true,
        [LEVEL_NIGHTMARE_CCM] = true,
        [LEVEL_NIGHTMARE_BBH] = true,
        [LEVEL_NIGHTMARE_PSS] = true,
        [LEVEL_NIGHTMARE_HMC] = true,
        [LEVEL_NIGHTMARE_LLL] = true,
        [LEVEL_NIGHTMARE_SSL] = true,
        [LEVEL_NIGHTMARE_DDD] = true,
        [LEVEL_NIGHTMARE_SL] = true,
        [LEVEL_NIGHTMARE_WDW] = true,
        [LEVEL_NIGHTMARE_THI] = true,
        [LEVEL_NIGHTMARE_TTC] = true,
        [LEVEL_NIGHTMARE_RR] = true,
        [LEVEL_NIGHTMARE_COTMC] = true,
        [LEVEL_NIGHTMARE_VCUTM] = true,
        [LEVEL_NIGHTMARE_TOTWC] = true,
        [LEVEL_NIGHTMARE_BITDW] = true,
        [LEVEL_NIGHTMARE_BITFS] = true,
        [LEVEL_NIGHTMARE_BITS] = true,
        [LEVEL_NIGHTMARE_CG] = true,
    }
	
    if nightmareLevels[gNetworkPlayers[0].currLevelNum] then
        if m.pos.y + 40 < gGlobalSyncTable.floodLevel then
            m.health = 0xFF
                end			
            end			
        end
    end		
end	

local function on_pause_exit()
    if network_is_server() then
        network_send(true, { restart = true })
        level_restart()
    end

    return false
end

--- @param m MarioState
local function allow_hazard_surface(m)
    if m.health <= 0xFF then return false end
    return true
end

-- thanks Peachy
--- @param o Object
local function on_object_unload(o)
    local m = gMarioStates[0]
    if (o.header.gfx.node.flags & GRAPH_RENDER_INVISIBLE) == 0 and obj_has_behavior_id(o, id_bhv1Up) == 1 and obj_check_hitbox_overlap(o, m.marioObj) then
        m.healCounter = 31
        m.hurtCounter = 0
    end
end

local function on_packet_receive(dataTable)
    if dataTable.restart then level_restart() end
end

function wrapNumber(num, max)
    return (num % (max + 1) + max + 1) % (max + 1)
end

-- Pursuer/Trollface Skin API
_G.floodExpanded = {
    trollface_skin = function (model)
        eTrollProperties.skin = model
    end
}

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_BEFORE_PHYS_STEP, before_phys_step)
hook_event(HOOK_UPDATE, remove_water)
hook_event(HOOK_ON_LEVEL_INIT, remove_water)
hook_event(HOOK_ALLOW_INTERACT, allow_interact)
hook_event(HOOK_ON_DEATH, on_death)
hook_event(HOOK_ON_PAUSE_EXIT, on_pause_exit)
hook_event(HOOK_ALLOW_HAZARD_SURFACE, allow_hazard_surface)
hook_event(HOOK_ON_OBJECT_UNLOAD, on_object_unload)
hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)
